/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.panels;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.frames.CrashScreen;
import swedtech.mcskinedit.frames.ProgramWindow;
import swedtech.mcskinedit.offlinemode.HTTPServer;

public class PreviewPane
extends JPanel {
    private static final String JARDOWNLOADURL = "http://minecraft.net/skin/skintest2.jar";
    private final String DEFAULTSKIN = "http://www.minecraft.net/img/char.png";
    private static final String MODELPREVIEW = "net.minecraft.skintest.ModelPreview";
    private static final String ZOMBIE = "net.minecraft.skintest.math.Zombie";
    private static final String BITMAP = "net.minecraft.skintest.gfx.Bitmap";
    private static final String SCREENBITMAP = "net.minecraft.skintest.gfx.ImageBitmap";
    private File jar = new File(ProgramWindow.LOCATION + File.separator + "skintest2.jar");
    private Method bitMapSetPixels;
    private Object bitmapObj;
    private boolean broken;
    private boolean started;
    private Canvas modelPreviewObj;
    private Class modelPreview;
    private Class screenBitmapClass;
    private Object screenBitmapObj;
    private Field screenBitmapField;
    private Field pausedField;

    public PreviewPane() {
        this.setPreferredSize(new Dimension(320, 320));
        if (!this.jar.exists() && !this.getJar()) {
            return;
        }
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{this.jar.toURI().toURL()});
            this.modelPreview = loader.loadClass(MODELPREVIEW);
            Class<?> zombie = loader.loadClass(ZOMBIE);
            Class<?> bitmap = loader.loadClass(BITMAP);
            this.screenBitmapClass = loader.loadClass(SCREENBITMAP);
            int port = new HTTPServer().startServer();
            String url = "http://localhost:" + port;
            this.modelPreviewObj = (Canvas)this.modelPreview.getConstructors()[0].newInstance(2, url);
            Field zombieField = this.modelPreview.getDeclaredField("zombie");
            zombieField.setAccessible(true);
            Object zombieObj = zombieField.get(this.modelPreviewObj);
            Field bitmapField = zombie.getDeclaredField("texture");
            while ((this.bitmapObj = bitmapField.get(zombieObj)) == null) {
            }
            int[] arg = new int[]{};
            this.bitMapSetPixels = bitmap.getDeclaredMethod("setPixels", arg.getClass());
            this.bitMapSetPixels.setAccessible(true);
            this.add(this.modelPreviewObj);
        }
        catch (Exception ex) {
            this.broken = true;
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Preview functionallity corrupted!\n\nTry downloading \"skintest2.jar\" manually!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getJar() {
        JFrame feed = new JFrame(Launcher.TITLE + " downloader");
        JPanel pane = new JPanel(new BorderLayout());
        JLabel text = new JLabel("Please wait...");
        JProgressBar bar = new JProgressBar(0, 100);
        feed.add(pane);
        pane.add((Component)text, "North");
        pane.add((Component)bar, "South");
        feed.setDefaultCloseOperation(3);
        bar.setStringPainted(true);
        feed.setResizable(false);
        feed.pack();
        feed.setLocationRelativeTo(null);
        feed.setVisible(true);
        try {
            int cur;
            String loc = JOptionPane.showInputDialog(feed, "The preview library doesn't exist! Please select the URL to download it:", JARDOWNLOADURL);
            if (loc == null) {
                this.broken = true;
                boolean bl = false;
                return bl;
            }
            bar.setIndeterminate(true);
            text.setText("Connecting...");
            URL url = new URL(loc);
            URLConnection cnct = url.openConnection();
            BufferedInputStream stream = new BufferedInputStream(cnct.getInputStream());
            bar.setIndeterminate(false);
            text.setText("Downloading...");
            Vector<Integer> data = new Vector<Integer>();
            boolean showPer = true;
            if (cnct.getContentLength() == -1) {
                showPer = false;
                bar.setIndeterminate(true);
            } else {
                bar.setIndeterminate(false);
            }
            int dl = 0;
            while ((cur = stream.read()) != -1) {
                data.add(cur);
                if (!showPer || dl % 100 != 0) continue;
                bar.setValue((int)((float)(++dl) / (float)cnct.getContentLength() * 100.0f));
            }
            stream.close();
            text.setText("Saving file...");
            bar.setIndeterminate(true);
            BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(this.jar));
            for (int i = 0; i < data.size(); ++i) {
                file.write((Integer)data.get(i));
            }
            file.close();
            text.setText("Dowload complete!");
            bar.setIndeterminate(false);
            bar.setValue(100);
            bar.setString("Complete!");
            JOptionPane.showMessageDialog(feed, "Preview functionallity downloaded successfully!");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.broken = true;
            ex.printStackTrace();
            new CrashScreen("Error downloading preview:\n" + CrashScreen.exStr(ex), false);
            boolean bl = false;
            return bl;
        }
        finally {
            feed.setVisible(false);
            feed.dispose();
        }
    }

    public void start() {
        if (this.broken) {
            return;
        }
        try {
            this.modelPreview.getDeclaredMethod("start", new Class[0]).invoke((Object)this.modelPreviewObj, new Object[0]);
            this.started = true;
        }
        catch (Exception ex) {
            this.broken = true;
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Preview functionallity corrupted!\n\nTry downloading \"skintest2.jar\" manually!");
        }
    }

    public void stop() {
        if (this.broken) {
            return;
        }
        try {
            this.modelPreview.getDeclaredMethod("stop", new Class[0]).invoke((Object)this.modelPreviewObj, new Object[0]);
            this.started = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setImage(int[] img) {
        if (!this.started) {
            return;
        }
        try {
            this.bitMapSetPixels.invoke(this.bitmapObj, new Object[]{img});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        if (!this.broken) {
            super.paint(g);
        } else {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            FontMetrics fm = this.getFontMetrics(g.getFont());
            String error = "Preview broken";
            g.setColor(Color.red);
            g.drawString(error, this.getSize().width / 2 - fm.stringWidth(error) / 2, this.getSize().height / 2 + fm.getHeight() / 2);
        }
    }

    public BufferedImage getScreenshot() {
        if (this.broken) {
            return null;
        }
        try {
            if (this.screenBitmapField == null) {
                this.screenBitmapField = this.modelPreview.getDeclaredField("screenBitmap");
                this.screenBitmapField.setAccessible(true);
            }
            if (this.screenBitmapObj == null) {
                this.screenBitmapObj = this.screenBitmapField.get(this.modelPreviewObj);
            }
            return (BufferedImage)this.screenBitmapClass.getMethod("getImage", new Class[0]).invoke(this.screenBitmapObj, new Object[0]);
        }
        catch (Exception ex) {
            new CrashScreen("Failed to grab previewer screenshot\n" + CrashScreen.exStr(ex), false);
            return null;
        }
    }

    public BufferedImage getScreenshot(double scaleY, double scaleX) {
        BufferedImage sc = this.getScreenshot();
        BufferedImage ret = new BufferedImage((int)(160.0 * scaleX), (int)(160.0 * scaleY), 2);
        ret.getGraphics().drawImage(sc, 0, 0, (int)(160.0 * scaleX), (int)(160.0 * scaleY), this);
        return ret;
    }

    public boolean setPaused(boolean bool) {
        try {
            if (this.pausedField == null) {
                this.pausedField = this.modelPreview.getDeclaredField("paused");
                this.pausedField.setAccessible(true);
            }
            this.pausedField.setBoolean(this.modelPreviewObj, bool);
            return true;
        }
        catch (Exception ex) {
            new CrashScreen("Failed to pause/unpause previewer\n" + CrashScreen.exStr(ex), false);
            return false;
        }
    }

    public boolean getPaused() {
        try {
            if (this.pausedField == null) {
                this.pausedField = this.modelPreview.getDeclaredField("paused");
                this.pausedField.setAccessible(true);
            }
            return this.pausedField.getBoolean(this.modelPreviewObj);
        }
        catch (Exception ex) {
            new CrashScreen("Failed read current pause on previewer\n" + CrashScreen.exStr(ex), false);
            return false;
        }
    }
}

