/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.frames;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import swedtech.mcskinedit.Launcher;
import swedtech.mcskinedit.classes.RadioButtonWithValue;
import swedtech.mcskinedit.classes.Settings;
import swedtech.mcskinedit.classes.VMenuItem;
import swedtech.mcskinedit.frames.AboutBox;
import swedtech.mcskinedit.frames.ControllsBox;
import swedtech.mcskinedit.frames.CrashScreen;
import swedtech.mcskinedit.frames.PartsPicker;
import swedtech.mcskinedit.frames.SliderOptionPane;
import swedtech.mcskinedit.icons.ProgramIcon;
import swedtech.mcskinedit.panels.EditArea;
import swedtech.mcskinedit.panels.PreviewPane;

public class ProgramWindow
implements ActionListener,
WindowListener {
    JFrame frame;
    EditArea ea;
    JColorChooser col;
    PreviewPane prew;
    JMenu bgimage;
    JMenu sett;
    public static String LOCATION = ".";

    public ProgramWindow() throws Exception {
        System.out.println("Copyright 2010 Patrik Swedman");
        if (LOCATION == null) {
            this.setLocation();
        }
        this.frame = new JFrame(Launcher.TITLE);
        this.frame.addWindowListener(this);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setResizable(false);
        this.frame.setLayout(new BorderLayout());
        new Thread(new Runnable(){

            public void run() {
                ProgramWindow.this.frame.setIconImages(ProgramIcon.getProgramIcons());
                System.out.println("Program icons loaded");
            }
        }).start();
        System.out.println("Load");
        this.col = new JColorChooser(Color.BLACK);
        this.prew = new PreviewPane();
        this.ea = new EditArea(this.frame, this.col, this.prew);
        JButton prewScr = new JButton("Take screenshot");
        prewScr.setActionCommand("previewscreenshot");
        prewScr.addActionListener(this);
        JPanel prewArea = new JPanel(new BorderLayout());
        prewArea.add((Component)this.prew, "North");
        prewArea.add((Component)prewScr, "South");
        this.frame.add((Component)prewArea, "East");
        this.frame.add((Component)this.col, "West");
        this.frame.add((Component)this.ea, "North");
        this.col.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ProgramWindow.this.ea.setColor(ProgramWindow.this.col.getColor());
            }
        });
        this.setupMenus();
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
        this.prew.start();
    }

    private void setupMenus() {
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu("File", true);
        JMenuItem filenew = new JMenuItem("New", 78);
        filenew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        filenew.setActionCommand("new");
        filenew.addActionListener(this);
        file.add(filenew);
        JMenuItem fileload = new JMenuItem("Load", 76);
        fileload.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileload.setActionCommand("load");
        fileload.addActionListener(this);
        file.add(fileload);
        JMenuItem filesave = new JMenuItem("Save", 83);
        filesave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        filesave.setActionCommand("save");
        filesave.addActionListener(this);
        file.add(filesave);
        JMenuItem filesaveas = new JMenuItem("Save As", 65);
        filesaveas.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        filesaveas.setActionCommand("saveas");
        filesaveas.addActionListener(this);
        file.add(filesaveas);
        file.addSeparator();
        JMenuItem fileexit = new JMenuItem("Exit", 69);
        fileexit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        fileexit.setActionCommand("exit");
        fileexit.addActionListener(this);
        file.add(fileexit);
        menu.add(file);
        JMenu edit = new JMenu("Edit");
        JMenuItem editundo = new JMenuItem("Undo", 85);
        editundo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        editundo.setActionCommand("undo");
        editundo.addActionListener(this);
        edit.add(editundo);
        JMenuItem editredo = new JMenuItem("Redo", 82);
        editredo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        editredo.setActionCommand("redo");
        editredo.addActionListener(this);
        edit.add(editredo);
        edit.addSeparator();
        JMenuItem editautoshade = new JMenuItem("Add noise", 65);
        editautoshade.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        editautoshade.setActionCommand("autoshade");
        editautoshade.addActionListener(this);
        edit.add(editautoshade);
        edit.addSeparator();
        JMenuItem editshowpicker = new JMenuItem("PartPicker", 80);
        editshowpicker.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        editshowpicker.setActionCommand("partpicker");
        editshowpicker.addActionListener(this);
        edit.add(editshowpicker);
        menu.add(edit);
        JMenu brush = new JMenu("Brushsize");
        ButtonGroup brushsize = new ButtonGroup();
        byte[] brushsizes = new byte[]{1, 2, 3, 4, 5, 6, 8, 10, 12};
        char chr = '1';
        for (byte size : brushsizes) {
            RadioButtonWithValue<Byte> cur = new RadioButtonWithValue<Byte>(size + "px", size, size == brushsizes[0]);
            cur.setActionCommand("setbrushsize");
            if (chr <= '9') {
                cur.setAccelerator(KeyStroke.getKeyStroke(chr));
                chr = (char)(chr + '\u0001');
            }
            cur.addActionListener(this);
            brushsize.add(cur);
            brush.add(cur);
        }
        menu.add(brush);
        this.sett = new JMenu("Settings");
        JCheckBoxMenuItem bgfront = new JCheckBoxMenuItem("Draw background behind image", this.ea.isDrawBgUnder());
        bgfront.setActionCommand("drawbgunder");
        bgfront.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        bgfront.addActionListener(this);
        this.sett.add(bgfront);
        JCheckBoxMenuItem prewold = new JCheckBoxMenuItem("Use old behavior for previewer", !this.ea.isPrewiewSimmulate());
        prewold.setActionCommand("previewbehavior");
        prewold.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        prewold.addActionListener(this);
        this.sett.add(prewold);
        JMenu bgalpha = new JMenu("Background Alpha");
        ButtonGroup bgalphag = new ButtonGroup();
        RadioButtonWithValue<Float> nobgalpha = new RadioButtonWithValue<Float>("Do not draw background", Float.valueOf(0.0f));
        nobgalpha.setActionCommand("setbgalpha");
        nobgalpha.addActionListener(this);
        nobgalpha.setAccelerator(KeyStroke.getKeyStroke(521, 8));
        bgalphag.add(nobgalpha);
        bgalpha.add(nobgalpha);
        int acc = 49;
        for (float a = 0.1f; a < 1.0f; a += 0.1f) {
            RadioButtonWithValue<Float> cur = new RadioButtonWithValue<Float>((int)(a * 100.0f) + "%", Float.valueOf(a), this.ea.getBackgroundAlpha() == a);
            cur.setActionCommand("setbgalpha");
            if (acc <= 57) {
                cur.setAccelerator(KeyStroke.getKeyStroke(acc, 8));
                acc = (char)(acc + 1);
            }
            cur.addActionListener(this);
            bgalphag.add(cur);
            bgalpha.add(cur);
        }
        RadioButtonWithValue<Float> fullbgalpha = new RadioButtonWithValue<Float>("100%", Float.valueOf(1.0f));
        fullbgalpha.setActionCommand("setbgalpha");
        fullbgalpha.addActionListener(this);
        fullbgalpha.setAccelerator(KeyStroke.getKeyStroke(48, 8));
        bgalphag.add(fullbgalpha);
        bgalpha.add(fullbgalpha);
        this.sett.add(bgalpha);
        this.bgimage = new JMenu("Bachground Image");
        ButtonGroup bgimages = new ButtonGroup();
        JMenuItem bgcolor = new JMenuItem("Change background color", 98);
        bgcolor.setActionCommand("changebgcolor");
        bgcolor.addActionListener(this);
        this.sett.add(bgcolor);
        JMenuItem outsidecolor = new JMenuItem("Change outside color", 111);
        outsidecolor.setActionCommand("changeoutsidecolor");
        outsidecolor.addActionListener(this);
        this.sett.add(outsidecolor);
        menu.add(this.sett);
        this.createBackgroundMenu();
        JMenu help = new JMenu("Help");
        JMenuItem helpabout = new JMenuItem("About", 65);
        helpabout.setActionCommand("about");
        helpabout.addActionListener(this);
        help.add(helpabout);
        JMenuItem helpcontrol = new JMenuItem("Controlls", 67);
        helpcontrol.setActionCommand("control");
        helpcontrol.addActionListener(this);
        help.add(helpcontrol);
        menu.add(help);
        this.frame.setJMenuBar(menu);
    }

    private void createBackgroundMenu() {
        this.sett.remove(this.bgimage);
        this.bgimage = new JMenu("Background image");
        JMenuItem defimg = new JMenuItem("Default");
        defimg.setActionCommand("bgdefault");
        defimg.addActionListener(this);
        this.bgimage.add(defimg);
        File bgfolder = new File(LOCATION + File.separator + "backgrounds" + File.separator);
        System.out.println(bgfolder);
        if (bgfolder.exists() && bgfolder.isDirectory()) {
            this.bgimage.addSeparator();
            class ImageFileFilter
            implements FileFilter {
                private final String[] supported;

                public ImageFileFilter() {
                    ArrayList<String> tmp = new ArrayList<String>();
                    for (String s : ImageIO.getReaderFileSuffixes()) {
                        s = s.toLowerCase();
                        for (String h : tmp) {
                            if (!s.equals(h)) continue;
                        }
                        tmp.add(s);
                    }
                    this.supported = new String[tmp.size()];
                    for (int i = 0; i < tmp.size(); ++i) {
                        this.supported[i] = (String)tmp.get(i);
                    }
                }

                public boolean accept(File pathname) {
                    if (!pathname.canRead() || !pathname.isFile()) {
                        return false;
                    }
                    String name = pathname.getName().toLowerCase();
                    for (String s : this.supported) {
                        if (!name.endsWith(s.toLowerCase())) continue;
                        try {
                            Image tmp = Toolkit.getDefaultToolkit().getImage(pathname.toURI().toURL());
                            while (tmp.getWidth(ProgramWindow.this.frame) == -1 || tmp.getHeight(ProgramWindow.this.frame) == -1) {
                            }
                            return tmp.getWidth(ProgramWindow.this.frame) % 64 == 0 && tmp.getHeight(ProgramWindow.this.frame) % 32 == 0;
                        }
                        catch (MalformedURLException ex) {
                            return false;
                        }
                    }
                    return false;
                }
            }
            for (File f : bgfolder.listFiles(new ImageFileFilter())) {
                VMenuItem c = new VMenuItem(f.getName(), f);
                c.addActionListener(this);
                c.setActionCommand("changebg");
                this.bgimage.add(c);
            }
        }
        this.bgimage.addSeparator();
        JMenuItem rel = new JMenuItem("Refresh list");
        rel.setActionCommand("reloadbgs");
        rel.addActionListener(this);
        this.bgimage.add(rel);
        this.sett.add(this.bgimage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("load")) {
            this.ea.showLoadImage();
        } else if (e.getActionCommand().equals("save")) {
            this.ea.saveImage();
        } else if (e.getActionCommand().equals("saveas")) {
            this.ea.showSaveImage();
        } else if (e.getActionCommand().equals("new")) {
            this.ea.showNewImage();
        } else if (!e.getActionCommand().equals("settings")) {
            if (e.getActionCommand().equals("about")) {
                new AboutBox(this.frame);
            } else if (e.getActionCommand().equals("exit")) {
                this.windowClosing(null);
            } else if (e.getActionCommand().equals("setbrushsize")) {
                if (!(e.getSource() instanceof RadioButtonWithValue)) {
                    return;
                }
                RadioButtonWithValue cur = (RadioButtonWithValue)e.getSource();
                this.ea.setBrushsize((Byte)cur.getValue());
            } else if (e.getActionCommand().equals("drawbgunder")) {
                if (!(e.getSource() instanceof JCheckBoxMenuItem)) {
                    return;
                }
                JCheckBoxMenuItem cur = (JCheckBoxMenuItem)e.getSource();
                this.ea.setDrawBgUnder(cur.isSelected());
            } else if (e.getActionCommand().equals("previewbehavior")) {
                if (!(e.getSource() instanceof JCheckBoxMenuItem)) {
                    return;
                }
                JCheckBoxMenuItem cur = (JCheckBoxMenuItem)e.getSource();
                this.ea.setPrewiewSimmulate(!cur.isSelected());
                this.ea.updatePreview();
            } else if (e.getActionCommand().equals("setbgalpha")) {
                if (!(e.getSource() instanceof RadioButtonWithValue)) {
                    return;
                }
                RadioButtonWithValue cur = (RadioButtonWithValue)e.getSource();
                this.ea.setBackgroundAlpha(((Float)cur.getValue()).floatValue());
            } else if (e.getActionCommand().equals("undo")) {
                this.ea.undo();
            } else if (e.getActionCommand().equals("redo")) {
                this.ea.redo();
            } else if (e.getActionCommand().equals("changebgcolor")) {
                Color nev = JColorChooser.showDialog(this.frame, "Please select a new background color", this.ea.getBackground());
                if (nev != null) {
                    this.ea.setBackground(nev);
                }
            } else if (e.getActionCommand().equals("changeoutsidecolor")) {
                Color nev = JColorChooser.showDialog(this.frame, "Please select a new color for the outside area", this.ea.getOutsideColor());
                if (nev != null) {
                    this.ea.setOutsideColor(nev);
                }
            } else if (e.getActionCommand().equals("control")) {
                new ControllsBox(this.frame);
            } else if (e.getActionCommand().equals("bgdefault")) {
                this.ea.setBackground(Toolkit.getDefaultToolkit().getImage(EditArea.class.getResource("background.png")));
            } else if (e.getActionCommand().equals("changebg")) {
                if (!(e.getSource() instanceof VMenuItem)) {
                    return;
                }
                try {
                    VMenuItem v = (VMenuItem)e.getSource();
                    this.ea.setBackground(Toolkit.getDefaultToolkit().getImage(v.getValue().toURI().toURL()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (e.getActionCommand().equals("reloadbgs")) {
                this.createBackgroundMenu();
            } else if (e.getActionCommand().equals("autoshade")) {
                float force = SliderOptionPane.show(this.frame);
                this.ea.autoShade(0.1f * (force / 100.0f));
            } else if (e.getActionCommand().equals("previewscreenshot")) {
                boolean paused = this.prew.getPaused();
                this.prew.setPaused(true);
                try {
                    BufferedImage img = this.prew.getScreenshot(2.0, 2.0);
                    JFileChooser ch = new JFileChooser(Settings.getInstance().getProperty("lastscreenshotlocation", System.getProperty("user.dir")));
                    ch.setDialogType(1);
                    if (ch.showSaveDialog(this.frame) != 0) {
                        return;
                    }
                    File save = ch.getSelectedFile();
                    if (save == null) {
                        JOptionPane.showMessageDialog(this.frame, "Invalid filename!", "Error saving file", 0);
                        Settings.getInstance().setProperty("lastscreenshotlocation", save.getParentFile().getCanonicalPath());
                        return;
                    }
                    if (!save.getAbsolutePath().toLowerCase().endsWith(".png")) {
                        System.out.println("Appended .png to screenshot filename");
                        save = new File(save.getAbsolutePath() + ".png");
                    }
                    if (!save.canWrite() && save.exists()) {
                        JOptionPane.showMessageDialog(this.frame, "File exists already and can't be overwritten", "Error saving file", 0);
                        return;
                    }
                    if (save.exists() && JOptionPane.showConfirmDialog(this.frame, "The file already exists.\nDo you want to overwrite the old file?", "Overwrite", 0, 3) == 1) {
                        return;
                    }
                    ImageIO.write((RenderedImage)img, "png", save);
                }
                catch (IOException ex) {
                    new CrashScreen("Error saving screenshot:\n" + CrashScreen.exStr(ex), false);
                }
                finally {
                    this.prew.setPaused(paused);
                }
            } else if (e.getActionCommand().equals("partpicker")) {
                this.ea.getImage().append(PartsPicker.show(this.frame, this.ea.getImage()));
                this.ea.repaint();
                this.ea.updatePreview();
            } else {
                System.err.println("Warning: Unknown actioncommand: " + e.getActionCommand() + "! (please report this)");
            }
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.ea.isSaved()) {
            this.prew.stop();
            System.exit(0);
        } else {
            int res = JOptionPane.showConfirmDialog(this.frame, "You've got unsaved changes.\n\nDo you want to save your changes?", "Confirm", 1);
            if (res == 0) {
                this.ea.showSaveImage();
            } else if (res == 1) {
                this.prew.stop();
                System.exit(0);
            }
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void setLocation() throws URISyntaxException {
        LOCATION = Launcher.DEBUG ? new File(".").getPath() : new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().toURI().getPath();
    }
}

