/*
 * Decompiled with CFR 0.152.
 */
package swedtech.mcskinedit.classes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Properties;
import swedtech.mcskinedit.frames.ProgramWindow;

public class Settings
extends Properties {
    private static Settings instance = null;
    private static final String[] locations = new String[]{ProgramWindow.LOCATION + File.separator + "settings.xml", "settings.xml", System.getProperty("user.dir") + File.separator + ".skinedit" + File.separator + "settings.xml"};

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
            boolean success = false;
            for (String l : locations) {
                try {
                    System.out.println("Trying to load " + l);
                    BufferedInputStream i = new BufferedInputStream(new FileInputStream(l));
                    instance.loadFromXML(i);
                    System.out.println("Success!");
                    success = true;
                    break;
                }
                catch (IOException ex) {
                    System.out.println("Failed!");
                }
            }
        }
        return instance;
    }

    public Object setProperty(String key, String def) {
        super.setProperty(key, def);
        System.out.println("Saving settings...");
        new Thread(new Runnable(){

            public void run() {
                boolean success = false;
                for (String l : locations) {
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(l));
                        Settings.this.storeToXML(out, "\nSkinEdit settings\nAutomaticly generated at " + Calendar.getInstance().getTime().toString() + "\n\nBe careful when editing this file - don't edit unless you know what you are doing!\n");
                        success = true;
                        break;
                    }
                    catch (IOException ex) {
                        System.out.println("Failed to save as " + l);
                    }
                }
                System.out.println(success ? "Settings saved!" : "Couldn't save settings!");
            }
        }).start();
        return null;
    }
}

